<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Tables\Post;

use Erlage\Photogram\Data\Tables\AbstractTable;
use Erlage\Photogram\Data\Models\Post\Comment\PostCommentModel;
use Erlage\Photogram\Data\Models\Post\Comment\PostCommentValidator;

final class PostCommentTable extends AbstractTable
{
    /*
    |--------------------------------------------------------------------------
    | table data
    |--------------------------------------------------------------------------
    */

    const TABLE_NAME = 'postcomment';

    /*
    |--------------------------------------------------------------------------
    | fields/attributes
    |--------------------------------------------------------------------------
    */

    const ID = 'id';

    const OWNER_USER_ID = 'owner_user_id';

    const PARENT_POST_ID = 'parent_post_id';

    const REPLY_TO_POST_COMMENT_ID = 'reply_to_postcomment_id';

    const DISPLAY_TEXT = 'display_text';

    const CACHE_LIKES_COUNT = 'cache_likes_count';

    const CACHE_COMMENTS_COUNT = 'cache_comments_count';

    const STAMP_REGISTRATION = 'stamp_registration';

    const STAMP_LAST_UPDATE = 'stamp_last_update';

    /*
    |--------------------------------------------------------------------------
    | all properties must provide their camel case equivalent
    |--------------------------------------------------------------------------
    */

    const CAMEL_CASE_MAP = array(
        self::ID => 'id',

        self::OWNER_USER_ID             => 'ownerUserId',
        self::PARENT_POST_ID            => 'parentPostId',
        self::REPLY_TO_POST_COMMENT_ID  => 'replyToPostCommentId',

        self::DISPLAY_TEXT => 'displayText',

        self::CACHE_LIKES_COUNT    => 'cacheLikesCount',
        self::CACHE_COMMENTS_COUNT => 'cacheCommentsCount',

        self::STAMP_REGISTRATION => 'stampRegistration',
        self::STAMP_LAST_UPDATE  => 'stampLastUpdate',
    );

    /*
    |--------------------------------------------------------------------------
    | required attributes
    |--------------------------------------------------------------------------
    */

    public static function getPrimaryAttribute(): string
    {
        return self::ID;
    }

    public static function getRegistrationStampAttribute(): string
    {
        return self::STAMP_REGISTRATION;
    }

    public static function getLastUpdateStampAttribute(): string
    {
        return self::STAMP_LAST_UPDATE;
    }

    public static function getOwnerAttribute(): string
    {
        return self::OWNER_USER_ID;
    }

    /*
    |--------------------------------------------------------------------------
    | meta getters
    |--------------------------------------------------------------------------
    */

    public static function getTableName(): string
    {
        return self::TABLE_NAME;
    }

    public static function getModelClassName(): string
    {
        return PostCommentModel::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | table properties getters
    |--------------------------------------------------------------------------
    */

    public static function allAttributes(): array
    {
        return self::CAMEL_CASE_MAP;
    }

    /*
    |--------------------------------------------------------------------------
    | table modifiers
    |--------------------------------------------------------------------------
    */

    public static function validators(): array
    {
        return array(
            self::DISPLAY_TEXT => array(PostCommentValidator::erlClass(), self::CAMEL_CASE_MAP[self::DISPLAY_TEXT]),
        );
    }
}
